/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensioneditor.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsUtilityCompat;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.tools.DynamicDimensionManager;
import mcjty.rftoolsdim.modules.dimensionbuilder.blocks.DimensionBuilderTileEntity;
import mcjty.rftoolsdim.modules.dimensioneditor.DimensionEditorConfig;
import mcjty.rftoolsdim.modules.dimensioneditor.DimensionEditorModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class DimensionEditorTileEntity
extends TickingTileEntity {
    public static final EnumProperty<DimensionBuilderTileEntity.OperationType> OPERATIONTYPE = EnumProperty.m_61587_((String)"operationtype", DimensionBuilderTileEntity.OperationType.class);
    public static final int SLOT_INJECTINPUT = 0;
    public static final int SLOT_DIMENSIONTARGET = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(DimensionEditorTileEntity::isValidInput).in().out(), 0, 64, 24).slot(SlotDefinition.specific(DimensionBuilderTileEntity::isRealizedTab).in().out(), 1, 118, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 1) {
            return DimensionBuilderTileEntity.isRealizedTab(stack);
        }
        return DimensionEditorTileEntity.isValidInput(stack);
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)DimensionEditorConfig.EDITOR_MAXENERGY.get()).intValue(), (long)((Integer)DimensionEditorConfig.EDITOR_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dimension Editor").containerSupplier(DefaultContainerProvider.container(DimensionEditorModule.CONTAINER_DIMENSION_EDITOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @GuiValue
    private int editPercentage = 0;
    private int ticksLeft = -1;
    private int ticksCost = -1;
    private int rfPerTick = -1;
    private int state = 0;

    public DimensionEditorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)DimensionEditorModule.TYPE_DIMENSION_EDITOR.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(DimensionEditorTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimensions/dimension_editor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.ROTATION;
            }

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{OPERATIONTYPE});
            }
        };
    }

    private static boolean isValidInput(ItemStack s) {
        if (DimensionEditorTileEntity.isMatterReceiver(s)) {
            return true;
        }
        return (Boolean)DimensionEditorConfig.TNT_CAN_DESTROY_DIMENSION.get() != false && DimensionEditorTileEntity.isTNT(s);
    }

    public int getEditPercentage() {
        return this.editPercentage;
    }

    public void tickServer() {
        this.editPercentage = this.ticksLeft == -1 ? 0 : (this.ticksCost - this.ticksLeft) * 100 / this.ticksCost;
        ItemStack injectableItemStack = this.validateInjectableItemStack();
        if (injectableItemStack.m_41619_()) {
            return;
        }
        ItemStack dimensionItemStack = this.validateDimensionItemStack();
        if (dimensionItemStack.m_41619_()) {
            return;
        }
        if (this.ticksLeft == -1) {
            String dimension = dimensionItemStack.m_41784_().m_128461_("dimension");
            ResourceLocation id = new ResourceLocation(dimension);
            DimensionData data = PersistantDimensionManager.get(this.f_58857_).getData(id);
            if (DimensionEditorTileEntity.isMatterReceiver(injectableItemStack)) {
                this.ticksCost = 1000;
                this.rfPerTick = 200;
            } else if (DimensionEditorTileEntity.isTNT(injectableItemStack)) {
                this.ticksCost = 600;
                this.rfPerTick = 10;
            } else {
                DimletKey key = DimletTools.getDimletKey(injectableItemStack);
                DimletSettings settings = DimletDictionary.get().getSettings(key);
                this.ticksCost = 1000 + settings.getTickCost();
                this.rfPerTick = 200 + settings.getCreateCost();
            }
            this.ticksLeft = this.ticksCost;
        } else {
            long rf = this.energyStorage.getEnergyStored();
            int rfpt = this.rfPerTick;
            if (rf >= (long)(rfpt = (int)((float)rfpt * (2.0f - this.infusable.getInfusedFactor()) / 2.0f))) {
                this.energyStorage.consumeEnergy((long)rfpt);
                --this.ticksLeft;
                if (this.ticksLeft <= 0) {
                    String dimension = dimensionItemStack.m_41784_().m_128461_("dimension");
                    ResourceLocation id = new ResourceLocation(dimension);
                    if (DimensionEditorTileEntity.isMatterReceiver(injectableItemStack)) {
                        Item item;
                        ServerLevel dimWorld = LevelTools.getLevel((Level)this.f_58857_, (ResourceKey)LevelTools.getId((ResourceLocation)id));
                        int y = this.findGoodReceiverLocation((Level)dimWorld);
                        if (y == -1) {
                            y = dimWorld.m_141928_() / 2;
                        }
                        if ((item = injectableItemStack.m_41720_()) instanceof BlockItem) {
                            BlockItem itemBlock = (BlockItem)item;
                            BlockState state = itemBlock.m_40614_().m_49966_();
                            BlockPos pos = new BlockPos(8, y, 8);
                            dimWorld.m_7731_(pos, state, 1);
                            Block block = dimWorld.m_8055_(pos).m_60734_();
                            String name = (String)NBTTools.getInfoNBT((ItemStack)injectableItemStack, CompoundTag::m_128461_, (String)"tpName", (Object)"");
                            long energy = (Long)NBTTools.getBlockEntityNBT((ItemStack)injectableItemStack, CompoundTag::m_128454_, (String)"Energy", (Object)0L);
                            RFToolsUtilityCompat.createTeleporter((WorldGenLevel)dimWorld, pos, name, (int)energy);
                            block.m_6402_((Level)dimWorld, pos, state, null, injectableItemStack);
                            dimWorld.m_7731_(pos.m_7494_(), Blocks.f_50016_.m_49966_(), 1);
                            dimWorld.m_7731_(pos.m_6630_(2), Blocks.f_50016_.m_49966_(), 1);
                        }
                    } else if (DimensionEditorTileEntity.isTNT(injectableItemStack)) {
                        this.safeDeleteDimension(id, dimensionItemStack);
                    } else {
                        DimletKey dimletKey = DimletTools.getDimletKey(injectableItemStack);
                    }
                    this.items.decrStackSize(0, 1);
                    this.stopInjecting();
                }
            }
        }
        this.m_6596_();
        this.setState();
    }

    private void safeDeleteDimension(ResourceLocation id, ItemStack dimensionTab) {
        DimensionData data = PersistantDimensionManager.get(this.f_58857_).getData(id);
        if (data == null) {
            return;
        }
        ServerLevel dimension = LevelTools.getLevel((Level)this.f_58857_, (ResourceLocation)id);
        int chunks = dimension.m_7726_().f_8325_.m_140394_();
        if (chunks > 0) {
            Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)"Dimension cannot be deleted. It is still in use!", (float)10.0f);
            return;
        }
        if (data.getOwner() != null) {
            if (this.getOwnerUUID() == null) {
                Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)"This machine has no proper owner and cannot delete dimensions!", (float)10.0f);
                return;
            }
            if (!this.getOwnerUUID().equals(data.getOwner())) {
                Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)"This machine's owner differs from the dimensions owner!", (float)10.0f);
                return;
            }
            RFToolsUtilityCompat.teleportationManager.removeReceiverDestinations(this.f_58857_, LevelTools.getId((ResourceLocation)id));
            PersistantDimensionManager mgr = PersistantDimensionManager.get(this.f_58857_);
            mgr.forget(id);
            DynamicDimensionManager.markDimensionForUnregistration(this.f_58857_.m_142572_(), (ResourceKey<Level>)LevelTools.getId((ResourceLocation)id));
            Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)("Removed dimension '" + id.toString() + "'!"), (float)10.0f);
            dimensionTab.m_41783_().m_128473_("dimension");
            int tickCost = dimensionTab.m_41783_().m_128451_("tickCost");
            dimensionTab.m_41783_().m_128405_("ticksLeft", tickCost);
        }
    }

    private int findGoodReceiverLocation(Level dimWorld) {
        int y = DimensionEditorTileEntity.findSuitableEmptySpot(dimWorld, 8, 8);
        return ++y;
    }

    public static int findSuitableEmptySpot(Level world, int x, int z) {
        int y = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
        if (y == -1) {
            return -1;
        }
        if (y == 0) {
            y = 65;
        }
        if (--y > world.m_141928_() - 5) {
            y = world.m_141928_() / 2;
        }
        BlockState state = world.m_8055_(new BlockPos(x, y + 1, z));
        while (state.m_60767_().m_76332_()) {
            if (++y > world.m_141928_() - 10) {
                return -1;
            }
            state = world.m_8055_(new BlockPos(x, y + 1, z));
        }
        return y;
    }

    private ItemStack validateInjectableItemStack() {
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.m_41619_()) {
            this.stopInjecting();
            return ItemStack.f_41583_;
        }
        if (DimensionEditorTileEntity.isMatterReceiver(itemStack)) {
            return itemStack;
        }
        if (DimensionEditorTileEntity.isTNT(itemStack)) {
            return this.canDeleteDimension(itemStack);
        }
        DimletKey key = DimletTools.getDimletKey(itemStack);
        DimletType type = key.type();
        return ItemStack.f_41583_;
    }

    private ItemStack canDeleteDimension(ItemStack itemStack) {
        if (!((Boolean)DimensionEditorConfig.TNT_CAN_DESTROY_DIMENSION.get()).booleanValue()) {
            Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)"Players cannot delete dimensions!", (float)10.0f);
            return ItemStack.f_41583_;
        }
        ItemStack dimensionStack = this.items.getStackInSlot(1);
        if (dimensionStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        String dimension = dimensionStack.m_41784_().m_128461_("dimension");
        ResourceLocation id = new ResourceLocation(dimension);
        DimensionData data = PersistantDimensionManager.get(this.f_58857_).getData(id);
        if (data == null) {
            Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)"Not a valid dimension!", (float)10.0f);
            return ItemStack.f_41583_;
        }
        if (this.getOwnerUUID() != null && this.getOwnerUUID().equals(data.getOwner())) {
            return itemStack;
        }
        Broadcaster.broadcast((Level)this.f_58857_, (int)this.f_58858_.m_123341_(), (int)this.f_58858_.m_123342_(), (int)this.f_58858_.m_123343_(), (String)"This machine's owner differs from the dimensions owner!", (float)10.0f);
        return ItemStack.f_41583_;
    }

    private static boolean isMatterReceiver(ItemStack itemStack) {
        return "rftoolsutility:matter_receiver".equals(Tools.getId((ItemStack)itemStack).toString());
    }

    private static boolean isTNT(ItemStack itemStack) {
        return itemStack.m_41720_() == Items.f_41996_;
    }

    private ItemStack validateDimensionItemStack() {
        ItemStack itemStack = this.items.getStackInSlot(1);
        if (itemStack.m_41619_()) {
            this.stopInjecting();
            return ItemStack.f_41583_;
        }
        String dimension = itemStack.m_41784_().m_128461_("dimension");
        ResourceLocation id = new ResourceLocation(dimension);
        DimensionData data = PersistantDimensionManager.get(this.f_58857_).getData(id);
        if (data == null) {
            this.stopInjecting();
            return ItemStack.f_41583_;
        }
        return itemStack;
    }

    private void stopInjecting() {
        this.setState();
        this.ticksLeft = -1;
        this.ticksCost = -1;
        this.rfPerTick = -1;
        this.m_6596_();
    }

    private void setState() {
        int oldstate = this.state;
        this.state = this.ticksLeft == 0 ? 0 : (this.ticksLeft == -1 ? 1 : ((this.ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        if (oldstate != this.state) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(OPERATIONTYPE, (Comparable)((Object)DimensionBuilderTileEntity.OperationType.values()[this.state])), 3);
            this.m_6596_();
        }
    }
}

